/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorFamiliarModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> FAMILIAR = TConstruct.createKey((String)"familiar_armor");

    public ArmorFamiliarModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorFamiliarModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(FAMILIAR, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(FAMILIAR, (Object)0);
            if (level > 0 && living instanceof Player) {
                Player player = (Player)living;
                if (attacker != null && player.m_21188_() != null && attacker.m_6095_() == player.m_21188_().m_6095_()) {
                    event.setAmount(event.getAmount() * (1.0f - 0.15f * (float)level));
                }
            }
        });
    }
}

